<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Notification;

use Erlage\Photogram\Data\Dtos\AbstractDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintValidatorDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintTransformerDTO;

class NotificationMetaTypeDTO extends AbstractDTO
{
    /**
     * to comply with DTO interface
     */
    use TraitComplaintValidatorDTO;
    use TraitComplaintTransformerDTO;

    /*
    |--------------------------------------------------------------------------
    | available types
    |--------------------------------------------------------------------------
    */

    const TYPE_LIKED_YOUR_POST = 'liked_your_post';

    /*
    |--------------------------------------------------------------------------
    | data
    |--------------------------------------------------------------------------
    */

    /**
     * @var string
     */
    private $type;

    /*
    |--------------------------------------------------------------------------
    | getters
    |--------------------------------------------------------------------------
    */

    public function getType(): string
    {
        return $this -> type;
    }

    /*
    |--------------------------------------------------------------------------
    | setters
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public function setType(string $type)
    {
        $this -> type = $type;

        return $this;
    }

    /*
    |--------------------------------------------------------------------------
    | from json
    |--------------------------------------------------------------------------
    */

    public static function fromString(string $data): self
    {
        return (new static()) -> setType((string) $data);
    }

    /*
    |--------------------------------------------------------------------------
    | serialization for json_encode
    |--------------------------------------------------------------------------
    */

    public function jsonSerialize()
    {
        return $this -> type;
    }

    /*
    |--------------------------------------------------------------------------
    | implement DTO methods
    |--------------------------------------------------------------------------
    */

    /**
     * @param NotificationMetaTypeDTO $displayItemDTO
     */
    public static function serialize($displayItemDTO): string
    {
        return (string) $displayItemDTO;
    }

    /**
     * @return NotificationMetaTypeDTO
     */
    public static function deSerialize(string $notificationTypeDTO)
    {
        $data = $notificationTypeDTO;

        return static::fromString($data);
    }
}
